<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Beautez Telehealth'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-50">
    <nav class="bg-blue-600 text-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center h-16">
                <div class="flex items-center">
                    <a href="/" class="text-lg sm:text-xl font-bold">Beautez Telehealth</a>
                </div>
                <div class="flex items-center space-x-2 sm:space-x-4">
                    <?php if(auth()->guard()->check()): ?>
                        <?php
                            $user = auth()->user();
                            $unreadCount = $user->unreadNotifications()->count();
                            $notificationRoute = '#';
                            if ($user->role === 'admin') {
                                $notificationRoute = route('admin.notifications');
                            } elseif ($user->role === 'doctor') {
                                $notificationRoute = route('doctor.notifications');
                            } elseif ($user->role === 'pharmacist') {
                                $notificationRoute = route('pharmacist.notifications');
                            }
                        ?>
                        
                        <a href="<?php echo e($notificationRoute); ?>" class="relative p-2 hover:bg-blue-700 rounded transition">
                            <i class="fas fa-bell text-lg sm:text-xl"></i>
                            <?php if($unreadCount > 0): ?>
                                <span class="absolute top-0 right-0 bg-red-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center font-bold">
                                    <?php echo e($unreadCount > 9 ? '9+' : $unreadCount); ?>

                                </span>
                            <?php endif; ?>
                        </a>
                        
                        <span class="text-xs sm:text-sm hidden sm:inline"><?php echo e($user->name); ?></span>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="bg-blue-700 hover:bg-blue-800 px-2 sm:px-4 py-2 rounded text-sm sm:text-base">
                                <i class="fas fa-sign-out-alt"></i> <span class="hidden sm:inline">Logout</span>
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>

    <main class="py-6">
        <?php if(session('success')): ?>
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mb-4">
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                    <?php echo e(session('success')); ?>

                </div>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mb-4">
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        <?php endif; ?>

        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>

<?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/layouts/app.blade.php ENDPATH**/ ?>